{any_include file="scp_page_start.tpl" wide=1}

<!-- $Id$ -->

<h1>OAuth - Sites You Can Access</h1>

{any_include file="scp_oauth_menu.tpl"}

<p>You have access permission to the following sites.  Some tokens are yours, some other tokens are made available by other members.</p>

<ul>
{foreach from=$tokens item="s"}
<li>
	<h3><a href="{$s.server_uri|escape}">{$s.server_uri_host|escape}<small>{$s.server_uri_path|escape}</small></a></h3>

	<form method="get" action="{$rel_path}module/OAuth/consumer/token/remove">
	<input type="hidden" name="token"        value="{$s.token|escape}" />
	<input type="hidden" name="consumer_key" value="{$s.consumer_key|escape}" />
	<p>

{if $any_config.debugging.oauth.show_tokens}
		Consumer Key: <strong>{$s.consumer_key|escape}</strong>
		{if $any_config.debugging.oauth.log_menu}
			<a href="{$rel_path}module/OAuth/log?osr_consumer_key={$s.consumer_key|escape:"url"}">[log]</a>
		{/if}
		Secret: <strong>{$s.consumer_secret|escape}</strong><br/>
		Token: <strong>{$s.token|escape}</strong>
		{if $any_config.debugging.oauth.log_menu}
			<a href="{$rel_path}module/OAuth/log?ost_token={$s.token|escape:"url"}">[log]</a>
		{/if}
		Secret: <strong>{$s.token_secret|escape}</strong><br/>
{/if}
		Issued on <strong>{$s.timestamp|date_format:"%Y-%m-%d %R"}</strong>

		<button type="submit" class="negative">
			Remove
		</button>
	</p>
	</form>
</li>
{foreachelse}
<li>
	<p class="notice">
		You don't have access to any server.  You can get access to other servers from the <a href="{$rel_path}module/OAuth/consumer/list">list of servers</a>.
	</p>
</li>
{/foreach}
</ul>

{any_include file="scp_page_end.tpl" wide=1}
