{any_include file="scp_page_start.tpl" wide=1}

<!-- $Id$ -->

{any_include file="scp_oauth_menu.tpl"}

{if $error == 'NOPERMISSION'}
<p class="error">
	You have no permission to change the server with consumer key {$smarty.get.consumer_key}
</p>

<p>
	<a href="{$rel_path}module/OAuth/consumer/list">Back to the list of servers</a>
</p>

{else}

{if $server.id}
<h1>{$server.server_uri|default:"Edit Key To Other Site"|escape}</h1>
{else}
<h1>OAuth - Add Key To Other Sites</h1>

{if $smarty.get.consumer_key && $error}
<p class="error">
	Could not find the server with consumer key {$smarty.get.consumer_key}.
</p>
{/if}

<h2>Before Adding A New Server</h2>

<p>
	Before you add a key, you should search the list of registered keys to see if the key
	or site has been registered before.
</p>

<form action="{$rel_path}module/OAuth/consumer/list" method="GET">
<p>
	<input class="text" style="float:left" type="text" name="q_mm" value="{$smarty.get.q_mm}" />
	<input class="submit" type="submit" value="Search Key" />
</p>
</form>

<div class="clear"></div>

<h2>Add The New Server</h2>
{/if}

<p>
	The site you want to register should have provided you with a consumer key, a consumer secret and some URLs.<br/>
	When you didn't obtain them, please check the documentation on the site you want to connect to.
</p>

<form action="{$rel_path}module/OAuth/consumer/register" method="POST">

{if $server.id}
<input type="hidden" name="id" value="{$server.id|escape}" />
{/if}

<fieldset>
	<legend>Consumer Key And Secret</legend>
	
	<p>
		<label for="">Consumer Key</label><br/>
		<input type="text" class="text" name="consumer_key" value="{$server.consumer_key|escape}" />
	</p>
	
	<p>
		<label for="">Consumer Secret</label><br/>
		<input type="text" class="text" name="consumer_secret" value="{$server.consumer_secret|escape}" />
	</p>
</fieldset>

<fieldset>
	<legend>Access URLs</legend>
	
	<p>
		<label for="">URL of the remote site</label><br/>
		<input type="text" class="text" name="server_uri" value="{$server.server_uri|escape}" />
	</p>

	<p>
		<label for="">URL for requesting tokens (request_token uri)</label><br/>
		<input type="text" class="text" name="request_token_uri" value="{$server.request_token_uri|escape}" />
	</p>

	<p>
		<label for="">URL for authorizing tokens (authorize uri)</label><br/>
		<input type="text" class="text" name="authorize_uri" value="{$server.authorize_uri|escape}" />
	</p>

	<p>
		<label for="">URL for obtaining access tokens (access_token uri)</label><br/>
		<input type="text" class="text" name="access_token_uri" value="{$server.access_token_uri|escape}" />
	</p>
</fieldset>

<fieldset>
	<legend>Signature Methods</legend>
	
	<p>
		Requests to the server will be signed with the secret keys provided. The signature can be calculated according
		to different algorithms.<br/>
		Check the algorithms that the site supports:
	<p>
		<input type="checkbox" class="checkbox" name="signature_methods[]" value="HMAC-SHA1" {if empty($server.consumer_key) || in_array('HMAC-SHA1', $server.signature_methods)}checked="checked"{/if} /> HMAC-SHA1<br/> 
		<input type="checkbox" class="checkbox" name="signature_methods[]" value="MD5" {if empty($server.consumer_key) || in_array('MD5', $server.signature_methods)}checked="checked"{/if}/> MD5<br/> 
		<input type="checkbox" class="checkbox" name="signature_methods[]" value="PLAINTEXT" {if empty($server.consumer_key) || in_array('PLAINTEXT', $server.signature_methods)}checked="checked"{/if} /> Plain Text<br/> 
	</p>
</fieldset>

<fieldset class="submit">
	<button class="submit" type="submit">
		{if $server.consumer_key}Update{else}Add{/if} Server And Connect
	</button>

{if $server.consumer_key}	
	<a class="button" href="{$rel_path}module/OAuth/consumer/delete?consumer_key={$server.consumer_key|escape}">
		Delete Server
	</a>
{/if}

	<a class="button">
		Cancel
	</a>
</fieldset>

</form>

{/if}

{any_include file="scp_page_end.tpl" wide=1}
