{any_include file="scp_page_start.tpl" wide=1}

<!-- $Id$ -->

<h1>OAuth - Authorize Access To Your Account</h1>

{any_include file="scp_oauth_menu.tpl"}

{if $finished}
<h2>Finished Authorization Request</h2>

{if $authorized}
<p class="success">
	You have allowed <em>{$server.application_title|escape}</em> to access your account and data.<br/>
	On the page <a href="{$rel_path}module/OAuth/server/token/list">Applications Using Your Account</a> you can retract this permission.
</p>
{else}
<p class="error">
	The application <em>{$server.application_title|escape}</em> will not have access to your account and data.
</p>
{/if}

<p>
	The authorization request is finished. You can now continue with your application or site.
</p>


{elseif empty($server)}

<h2>Enter Token</h2>

<p>
	Here you can allow an application or site to access your account and data.
</p>

{if array_key_exists(oauth_token, $smarty.request)}
<p class="error">
	The token did not match any token we know. Please check the token or let your application request a new one.
</p>
{else}
<p class="notice">
	We need to know which application or site requests access to your data. <br/>
	Please paste the authentication token as shown by your application or site in the field below.	
</p>
{/if}


<form action="{$rel_path}module/OAuth/authorize" method="get">

	<label>Enter the request token as shown by your application or site</label><br/>
	<input type="text" name="oauth_token" class="text" value="{$smarty.request.oauth_token}" />
	<br/>

	<button type="submit" class="button positive">
		Request Access
	</button>
</form>

{else}

<h2>Allow Or Deny Access</h2>

<p class="notice">
	The program <em>{$server.application_title|escape}</em> requests access to your account and your data on this server.<br/>
	You can <strong>allow</strong> or <strong>deny</strong> this access request.
</p>

<p>
	When you <strong>deny access</strong> then the program will not be able to interact with your data.
</p>

<p>
	When you <strong>allow access</strong> then the program can add, modify and delete all your data.
</p>


{if !empty($server.application_descr)}
<p>The program describes itself as:</p>
<blockquote>
	{$server.application_descr|escape|nl2br}
</blockquote>
{/if}

{if !$any_auth->isAuthenticated()}
<p class="notice">
	You are not logged on. You need to log on to allow or deny this request.
</p>

{any_include file="scp_logon.tpl"}
{else}

<form action="{$rel_path}module/OAuth/authorize" method="post">
	<!-- note that anyMeta auto escapes all request variables -->
	<input type="hidden" name="oauth_token" value="{$token.token|escape}" />

	<button type="submit" class="button positive" name="allow">
		Allow Access
	</button>
	
	<button type="submit" class="button negative" name="deny">
		Deny Access
	</button>
</form>

{/if}
{/if}

{any_include file="scp_page_end.tpl" wide=1}
