{any_include file="scp_page_start.tpl" wide=1}

<!-- $Id$ -->

<h1>OAuth - Make Test Request</h1>

{any_include file="scp_oauth_menu.tpl"}

<p>
<br/>
	Here you can make an OAuth request using one of your access keys.
</p>

{if $error}
<p style="width: 90%" class="error">
	{$error|escape}
</p>
{/if}

{if $log}
<h2>Request Log</h2>

<h3>Consumer Key &amp; Access Token</h3>
<dl>
	<dt>consumer key</dt>
	<dd>{$log.0.keys.osr_consumer_key|escape|default:"<i>not found</i>"}</dd>
	<dt>access token</dt>
	<dd>{$log.0.keys.ost_token|escape|default:"<i>not found</i>"}</dd>
</dl>

<h3>Base String For Signature</h3>

<p>
	{$log.0.base_string|escape}
</p>

<h3>Request sent to “http://{$smarty.post.url}”</h3>
<pre style="background-color: #ffe; padding: 10px; border: 1px solid #cc9">
{$log.0.sent|escape}
</pre>


<h3>Received {if $result}(http status {$result.code|escape}){/if}</h3>

<pre style="background-color: #ffe; padding: 10px; border: 1px solid #cc9">
{$log.0.received|escape}
</pre>


<h2><br/>New Request</h2>

{/if}

<form method="post" action="{$rel_path}module/OAuth/consumer/test">

<h2>
	http://<input class="text" style="font-size: 1em; width: 600px;" name="url" type="text" value="{$smarty.post.url}" />
</h2>


<h3>Parameters</h3>

<p>All parameter names <b>must be unique</b>, sorry :-).  Parameter names and values will be urlencoded.</p>

<table style="width:auto">
	<tr>
		<th>Name</th>
		<th>Value</th>
	</tr>
	<tr>
		<td><input style="width: 200px" class="text" type="text" name="par[]" value="{$smarty.post.par.0}" /></td>
		<td><input style="width: 400px" class="text" type="text" name="val[]" value="{$smarty.post.val.0}" /></td>
	</tr>
	<tr>
		<td><input style="width: 200px" class="text" type="text" name="par[]" value="{$smarty.post.par.1}" /></td>
		<td><input style="width: 400px" class="text" type="text" name="val[]" value="{$smarty.post.val.1}" /></td>
	</tr>
	<tr>
		<td><input style="width: 200px" class="text" type="text" name="par[]" value="{$smarty.post.par.2}" /></td>
		<td><input style="width: 400px" class="text" type="text" name="val[]" value="{$smarty.post.val.2}" /></td>
	</tr>
	<tr>
		<td><input style="width: 200px" class="text" type="text" name="par[]" value="{$smarty.post.par.3}" /></td>
		<td><input style="width: 400px" class="text" type="text" name="val[]" value="{$smarty.post.val.3}" /></td>
	</tr>
	<tr>
		<td><input style="width: 200px" class="text" type="text" name="par[]" value="{$smarty.post.par.4}" /></td>
		<td><input style="width: 400px" class="text" type="text" name="val[]" value="{$smarty.post.val.4}" /></td>
	</tr>
</table>

<h3>Optional Request Body</h3>

<p>
	You can add a http request body to your oauth request.  Leave empty to skip this.
</p>

<textarea name="body" style="width: 600px">{$smarty.post.body}</textarea>

<h3>Submit your request</h3>

<p>
	Click the request method to perform the request.<br/>

	<input class="submit" name="method" type="submit" value="POST" />
	<input class="submit" name="method" type="submit" value="GET" />
	<input class="submit" name="method" type="submit" value="PUT" />
</p>

</form>



{any_include file="scp_page_end.tpl" wide=1}
