/* -*- Mode: C; tab-width: 4; c-basic-offset: 4; indent-tabs-mode: nil -*- */
/* $Id: item.h 30245 2007-08-20 16:57:10Z marc $ */


#ifndef ITEM_H
#define ITEM_H

#include "hashtable.h"
#include "dep.h"

/**
 * Hashtable entry for storing key/value pairs with dependencies
 */
typedef struct _item {
	t_hashitem			h;
    unsigned			refcount;		/* number of connections using this item */
	unsigned			locked  : 1;	/* item has been locked, no garbage collection done */
	unsigned			gc      : 1;	/* item is garbage collection candidate */
    time_t				exptime;		/* expire time */

	// TODO: add recalculation costs for this entry (to give a weight for the garbage collector, cheaper things should be dropped earlier)

	t_depser			depserial;		/* max serial of dependency keys on item creation */
	unsigned			depct;			/* number of dependency keys */
	struct _dep **		deps;			/* all dependency keys */

	unsigned			queue_len;		/* when item is a queue, then this contains the queue size */
	struct _item **		queue_items;			
	
    unsigned int		datasz;			/* data size */
	void *				data;
} t_item;


void	item_init			( void );
t_item *item_find			( char *key );
t_item *item_alloc			( char *key, char *deps, int locked, time_t exptime, int nbytes );
int		item_remove			( char *key );
int		item_replace		( t_item * new_it );
void	item_ref			( t_item * it );
void	item_unref			( t_item * it );
void	item_gc				( unsigned long max_bytes );

#endif
