/* -*- Mode: C; tab-width: 4; c-basic-offset: 4; indent-tabs-mode: nil -*- */
/*
 * Hash table
 *
 * The hash function used here is by Bob Jenkins, 1996:
 *    <http://burtleburtle.net/bob/hash/doobs.html>
 *       "By Bob Jenkins, 1996.  bob_jenkins@burtleburtle.net.  
 *       You may use this code any way you wish, private, educational, 
 *       or commercial.  It's free."
 *
 * The rest of the file is licensed under the BSD license.  See LICENSE.
 *
 * $Id: hashtable.h 27706 2007-04-27 14:25:44Z marc $
 */

#ifndef HASHTABLE_H
#define HASHTABLE_H

typedef struct _hashitem {
	struct _hashitem *	h_next;
	char *				key;
} t_hashitem;

typedef struct _hashtable {
	unsigned int	power;
	unsigned long	mask;
	unsigned long	size;
	unsigned long	load;
	t_hashitem **	table;
} t_hashtable;


/**
 * Allocate the empty hashtable of HASHPOWER entries.
 */
extern t_hashtable * ht_new ( int power );

/**
 * Find a hashtable entry using the given key.
 * Returns either NULL or the hashtable item with the correct key.
 */
extern t_hashitem	* ht_find ( t_hashtable *ht, char *key );

/**
 * Insert an item into the hash table, no duplicate checks are performed. The key field of the item
 * must be set.
 */
extern int ht_insert ( t_hashtable *ht, t_hashitem *it );

/**
 * Remove the item with the given key
 */
extern t_hashitem * ht_remove ( t_hashtable *ht, char *key );

#endif

