{any_include file="scp_page_start.tpl" wide=1}

<!-- $Id$ -->

<h1>OAuth - Applications Using Your Account</h1>

{any_include file="scp_oauth_menu.tpl"}

{if empty($tokens)}
	<p class="notice">There are no applications with access to your data</p>
{else}

<p>The following sites have access to your data:</p>

<ul>
{foreach from=$tokens item="t"}

<li>
	<h2>
		<a href="{$t.application_uri|default:"#"|escape}">
			{$t.application_title|trim|default:$t.application_uri|default:"Unknown"|escape}
		</a>
	</h2>

	<form method="get" action="{$rel_path}module/OAuth/server/token/revoke">
	<input type="hidden" name="token" value="{$t.token|escape}" />
	<p>
{if $any_config.debugging.oauth.show_tokens}
		Consumer Key: <strong>{$t.consumer_key|escape}</strong>
		{if $any_config.debugging.oauth.log_menu}
			<a href="{$rel_path}module/OAuth/log?ocr_consumer_key={$t.consumer_key|escape:"url"}">[log]</a>
		{/if}
		Secret: <strong>{$t.consumer_secret|escape}</strong>
		<br/>
		Token: <strong>{$t.token|escape}</strong>
		{if $any_config.debugging.oauth.log_menu}
			<a href="{$rel_path}module/OAuth/log?oct_token={$t.token|escape:"url"}">[log]</a>
		{/if}
		Secret: <strong>{$t.token_secret|escape}</strong>
		<br/>
		</b>
{/if}
		Authorized on <b>{$t.timestamp}</b>, status <b>{if $t.enabled}enabled{else}disabled{/if}</b>
	
		<button type="submit" class="negative">
			Revoke
		</button>
	</p>
	
	</form>

</li>
{/foreach}
</ul>

{/if}

{any_include file="scp_page_end.tpl" wide=1}
