/* -*- Mode: C; tab-width: 4; c-basic-offset: 4; indent-tabs-mode: nil -*- */
/* $Id: depcached.h 27925 2007-05-15 15:39:15Z marc $ */


#ifndef DEPCACHED_H
#define DEPCACHED_H

#define DATA_BUFFER_SIZE 2048

#if defined(TCP_CORK) && !defined(TCP_NOPUSH)
#define TCP_NOPUSH TCP_CORK
#endif

#include "hashtable.h"
#include "dep.h"
#include "item.h"

#include <netinet/in.h>
#include <time.h>

struct stats {
    unsigned int		curr_items;
    unsigned int		total_items;
    unsigned long long  curr_bytes;
    unsigned int		curr_conns;
    unsigned int		total_conns;
    unsigned int		conn_structs;
    unsigned int		get_cmds;
    unsigned int		set_cmds;
    unsigned int		get_hits;
    unsigned int		get_misses;
    time_t				started;          /* when the process was started */
    unsigned long long	bytes_read;
    unsigned long long	bytes_written;
};

struct settings {
    unsigned int		maxbytes;
    int					maxconns;
    int					port;
    struct in_addr		interface;
    int					verbose;
    time_t				oldest_live;	/* ignore existing items older than this */
    int					evict_to_free;
};

#endif

