/* -*- Mode: C; tab-width: 4; c-basic-offset: 4; indent-tabs-mode: nil -*- */
/* $Id: dep.h 27761 2007-05-02 09:51:47Z marc $ */


#ifndef DEP_H
#define DEP_H

#include "hashtable.h"


/**
 * The serial number of dependency keys, incremented on every flush of any key
 */
typedef unsigned long long t_depser;


/**
 * Hashtable entry for dependency keys
 */
typedef struct _dep {
	t_hashitem			h;
	unsigned int		refcount;		/* number of items referring to this dependency key */
	t_depser			depserial;		/* serial nr of this dependency key */
} t_dep;


void			dep_init	  ( void );
t_dep *			dep_find	  ( char *key );
t_dep *			dep_find_ref  ( char *key );
void			dep_unref	  ( t_dep * d );

t_depser		dep_serial	   ( void );
t_depser		dep_serial_low ( void );

int				dep_touch	   ( char *key );
void			dep_touch_all  ( void );

char ** 		dep_path_split ( char * key );

#endif
